//---------------------------------------------------------------------------
#include "Lista.h"
//---------------------------------------------------------------------------
TLista::TLista()
{
	list=NULL;
	func=(pfunc)(strcmp);
	count=0;
}
//---------------------------------------------------------------------------
TLista::~TLista()
{
}
//---------------------------------------------------------------------------
int TLista::num_itens()
{
	return count;	
}
//---------------------------------------------------------------------------
void *TLista::obtem(int item)
{
	LISTA *busca,*ant;
	int cont=-1;

	ant=NULL;
	busca=list;
	while(busca!=NULL&&cont<item)
	{
		cont++;
		ant=busca;
		busca=(LISTA *)busca->prox;
	}
	if(cont!=item)
		return NULL;
	if(ant!=NULL)
		return ant->object;
	return list->object;
}
//---------------------------------------------------------------------------
void *TLista::remove_item(int item)
{
	LISTA *busca,*ant;
	void *object_ret;
	int cont=0;

	ant=NULL;
	busca=list;
	while(busca!=NULL&&cont<item)
	{
		cont++;
		ant=busca;
		busca=(LISTA *)busca->prox;
	}
	if(busca!=NULL)
	{
		if(ant==NULL)
			list=(LISTA *)list->prox;
		else
			ant->prox=busca->prox;
		object_ret = busca->object;

		free(busca);
		count--;
		return object_ret;
	}
	return NULL;
}
//---------------------------------------------------------------------------
void *TLista::remove_objeto(void *object)
{
	LISTA *busca,*ant;
	void *object_ret;

	ant=NULL;
	busca=list;
	while(busca!=NULL&&func(object,busca->object)==false)
	{
		ant=busca;
		busca=(LISTA *)busca->prox;
	}
	if(busca!=NULL)
	{
		if(ant==NULL)
			list=(LISTA *)list->prox;
		else
			ant->prox=busca->prox;
		object_ret = busca->object;
		free(busca);
		count--;
		return object_ret;
	}
	return NULL;
}
//---------------------------------------------------------------------------
void *TLista::procura(void *object)
{
	LISTA *busca;

	busca=list;

	while(busca!=NULL&&func(object,busca->object)==false)
		busca=(LISTA *)busca->prox;

	if(busca!=NULL)
		return busca->object;

	return NULL;
}
//---------------------------------------------------------------------------
bool TLista::adiciona(void *object)
{
	LISTA *novo,*busca,*ant;

	novo=(LISTA *)calloc(1,sizeof(LISTA));
	if(novo==NULL)
	{
		exit(EXIT_FAILURE);
	}

	ant=NULL;
	busca=list;
	while(busca!=NULL)
	{
		if(func(object,busca->object)==true)
			return false;
		ant=busca;
		busca=(LISTA *)busca->prox;
	}
	novo->prox=NULL;
	novo->object=object;

	if(ant==NULL)
		list=novo;
	else
		ant->prox=novo;
	count++;
	return true;
}
//---------------------------------------------------------------------------
void TLista::funcao(bool (*func)(void*,void*))
{
	if(func==NULL)
		this->func=(pfunc)(strcmp);
	else
		this->func=func;
}
//---------------------------------------------------------------------------
